// KURUMA Keizo:2025. thank you for your attention.
// 何かの役に立つなら "modified BSD license" か "X11 license" でご自由にどうぞ
// 気まぐれで更新し、バージョン番号などつけませんが、あしからず。

function Clone(dst, src) {
	for( var m in src )
		dst[m] = src[m];
}

/*
  モデルの座標系は、原点が中心、右がX+、上がY+
  画面の1pxに相当する量が qt
  canvas 幅512px -> 8192 (-4095..4096)
  canvas 高300px -> 4800 (-2400..2399)
*/

var qt = 16;		// クオンタイズというかスクリーン座標変換の係数。画面の1px相当の単位値
var qt_epsilon = 1;	// ゼロ割り防止判定、などのための微小値

function Node(i) {
	Clone(this, Node_proto);
	this.id = 100+i;
	this.z = i;
}
var Node_proto = {
	id:0, z:0, cx:0, cy:0, w:0, h:0
	,line_w:1.0*qt, line_col:'#000000'
	,text:""
	,img_idx:-1

	,
	init:function(text) {
		"use strict";
		this.cx = 0;
		this.cy = 0;
		this.w = 64*qt;
		this.h = 40*qt;
		this.line_w = 1.0*qt;
		this.line_col = '#000000';
		this.text = text;
	}
	,
	move:function() {
		"use strict";
		//テスト目的でなんか動かす
		switch (this.id) {
		default:
			{
				var deg = (this.z+1)/5;
				var rad = deg * Math.PI / 180;
				var x = this.cx, y = this.cy;
				var sin1 = Math.sin(rad);
				var cos1 = Math.cos(rad);
				var x2, y2;
				x2 = x * cos1 - y * sin1;
				y2 = x * sin1 + y * cos1;
				this.cx = x2;
				this.cy = y2;
			}
			break;
		}
	}
	,
	//spec: 外部の点(x2,y2)と自ノードの中心(cx,cy)に向かう線の、境界上の点(x,y)
	get_boundary_from_point:function(x2, y2) {
		"use strict";
		var bx = 0;
		var by = 0;
		var aw = Math.abs(this.w);
		var ah = Math.abs(this.h);
		var dx = x2 - this.cx;
		var dy = y2 - this.cy
		var x1 = Math.abs(dx);
		var y1 = Math.abs(dy);
		if (x1 < aw/2 && y1 < ah/2) {
			return [NaN, NaN];
		}
		if (aw < qt_epsilon || x1 < qt_epsilon) {
			bx = 0; by = ah/2 * Math.sign(dy);
		}
		else {
			var node_dhdw = ah/aw;
			var p1_dydx = dy/dx;
			if (Math.abs(p1_dydx) < Math.abs(node_dhdw)) {
				bx = aw/2 * Math.sign(dx);
				by = bx * p1_dydx;
			}
			else {
				by = ah/2 * Math.sign(dy);
				bx = by / p1_dydx;
			}
		}
		return [this.cx + bx, this.cy + by];
	}
}

function Edge(id) {
	Clone(this, Edge_proto);
	this.id = id;
}
var Edge_proto = {
	id:-1, n1:-1, n2:-1, z:0, line_w:1.0*qt, line_col:'#cc3333'
	,
	init:function(n1, n2) {
		"use strict";
		this.n1 = n1;
		this.n2 = n2;
	}
}

var model = {
	timerid:null
	,node_cnt:0		// 画面上に存在する数
	,node_max:16	// 実行空間で構造体が存在する数
	,nodes:null
	,node_idx:null
	,edge_cnt:0
	,edge_max:16
	,edges:null
	,edge_idx:null

	, //初期化
	init:function() {
		"use strict";
		try {
			this.nodes = new Array(this.node_max);
			this.node_idx = new Array();
			for (var i = 0; i < this.node_max; i++) {
				this.nodes[i] = new Node(i);
			}
			this.addNode("node100");
			this.addNode("node101");
			this.addNode("node102");
			this.addNode("node103");
			this.addNode("node104");
			this.addNode("node105");

			this.edges = new Array(this.edge_max);
			this.edge_idx = new Array();
			for (var i = 0; i < this.edge_max; i++) {
				this.edges[i] = new Edge(i);
			}
			this.addEdge(0,1);
			this.addEdge(1,2);
			this.addEdge(2,3);
			this.addEdge(2,4);

			this.reinit();

		} catch(ex) {
			console.error(ex);
			alert(ex);
		}
	}

	,
	reinit:function() {
		"use strict";
		//this.node_cnt = 0;
		//this.addNode();
		this.nodes[0].cx = (0)*qt;
		this.nodes[0].cy = (0)*qt;
		this.nodes[1].cx = (+50)*qt;
		this.nodes[1].cy = (-100)*qt;
		this.nodes[2].cx = (+100)*qt;
		this.nodes[2].cy = (+120)*qt;

		this.nodes[3].cx = (+10)*qt;
		this.nodes[3].cy = (+100)*qt;
		this.nodes[4].cx = (+120)*qt;
		this.nodes[4].cy = (-140)*qt;
		this.nodes[5].cx = (+140)*qt;
		this.nodes[5].cy = (+10)*qt;
	}

	, //追加
	addNode:function(text) {
		if (this.node_cnt < this.node_max) {
			this.nodes[this.node_cnt].init(text);
			this.node_idx.push(this.node_cnt);
			this.node_cnt += 1;
		}
	}
	,
	addEdge:function(n1, n2) {
		if (this.edge_cnt < this.edge_max) {
			this.edges[this.edge_cnt].init(n1, n2);
			this.edge_idx.push(this.edge_cnt);
			this.edge_cnt += 1;
		}
	}
	,
	dump_nodes:function() {
		console.debug("dump_nodes() cnt,max", this.node_cnt, this.node_max);
		var log_str = '[';
		for (i = 0; i < this.node_max; i++) {
			var n1 = this.nodes[i];
			log_str += '(' + n1.id +','+ n1.z +','+ n1.cx +','+ n1.cy +',"'+ n1.text+'")';
		}
		log_str += ']';
		console.debug("log_str ", log_str);

		console.debug("node_idx:", this.node_idx.toString());
	}

	, //Z値でソート
	sort_z:function() {
		model.node_idx.sort((lhs, rhs) => {
			//return lhs.z - rhs.z;
			return model.nodes[lhs].z - model.nodes[rhs].z;
		});
	}
	, //逆Y値でソート
	sort_y_neg:function() {
		model.node_idx.sort((lhs, rhs) => {
			//return -(lhs.cy - rhs.cy);
			return -(model.nodes[lhs].cy - model.nodes[rhs].cy);
		});
	}
	,
	select_node:function(mx, my) {
		//this.dump_nodes();
		for (var i=this.node_cnt-1; 0 <= i; i--) {
			var idx = this.node_idx[i];
			var n1 = this.nodes[idx];
			//console.log("%d, nodes[%d] cx,cy", i, idx, n1.cx, n1.cy);
			if ((Math.abs(n1.cx - mx) < Math.abs(n1.w)/2) &&
				(Math.abs(n1.cy - my) < Math.abs(n1.h)/2)) {
				return n1; // hit
			}
		}
		return null; // no hit
	}
	, //移動
	move:function() {
		for (i = 0; i < this.node_cnt; i++) {
			this.nodes[i].move();
		}
		this.colicheck();
	}
	, //衝突チェック
	colicheck:function() {
	}
	,
	start:function() {
		if (this.timerid == null)
			this.timerid = setInterval(this.onTimer, 1000.0/30); // 1/30秒
	}
	,
	stop:function() {
		clearTimeout(this.timerid);
		this.timerid = null;
	}
	,
	onTimer:function() {
		//移動
		model.move();
		//描画
		view.draw();
	}
}

////////////////////////

/*
  ビューの座標系は、原点がcanvas左上、右がX+、下がY+、
  画面の1pxが 1
*/

function get_modelXY_from_viewXY(x, y) {
	//console.log("XYXY", x,y);
	var mx, my;
	if (view.斜投影法) {
		var deg = view.斜投影法deg * Math.PI / 180;
		var cos = Math.cos(deg);
		mx = x + 2*cos*y - 3/2*view.h*cos;
		my = 2*y - view.h;
		x = mx;
		y = my;
		//console.log("XYXY", x,y);
	}
	mx = (x - view.w_d2) * qt;
	my = (y - view.h_d2) * -qt;
	//console.log("XYXY", mx,my);
	return [mx, my];
}

var view = {
	canvas:null
	,ctx:null
	,w:0
	,h:0
	,w_d2:0
	,h_d2:0
	,img_usrimg:null
	,val1:null
	,gframe:0
	,斜投影法:true
	,斜投影法deg:60

	,
	init:function() {
		this.canvas = document.getElementById("canvas0");
		this.ctx = this.canvas.getContext("2d");
		this.w = this.canvas.width;
		this.h = this.canvas.height;
		this.w_d2 = this.w/2;
		this.h_d2 = this.h/2;

		/*
		this.img_usrimg = new Array(4);
		this.img_usrimg[0] = document.getElementById("usrimg0");
		this.img_usrimg[1] = document.getElementById("usrimg1");
		this.img_usrimg[2] = document.getElementById("usrimg2");
		this.img_usrimg[3] = document.getElementById("usrimg3");
		*/

		this.val1 = document.getElementById("ui_val1");

		this.canvas.addEventListener("mousedown", this.ui_click_canvas);
		document.getElementById("ui_a").addEventListener("click", this.ui_click_a);
		document.getElementById("ui_b").addEventListener("click", this.ui_click_b);
		document.getElementById("ui_run").addEventListener("click", this.ui_click_run);
		document.getElementById("ui_stop").addEventListener("click", this.ui_click_stop);
		document.getElementById("ui_reset").addEventListener("click", this.ui_click_reset);
	}
	,
	get_arrow_tail:function(x1, y1, x2, y2, ar) {
		var dx,dy,r,tx,ty;
		dx = x2 - x1;
		dy = y2 - y1;
		r = Math.sqrt(dx**2 + dy**2);
		tx = ar/r * -dx;
		ty = ar/r * -dy;
		var x3,y3, x4,y4, x5,y5;
		x3 = x2 + tx;
		y3 = y2 + ty;
		x4 = x3 - ty/2;
		y4 = y3 + tx/2;
		x5 = x3 + ty/2;
		y5 = y3 - tx/2;
		return [x4,y4, x5,y5];
		//var x6,y6;
		//x6 = x2 + tx*2;
		//y6 = y2 + ty*2;
		//return [x4,y4, x5,y5, x6,y6];
	}
	,
	use_投影法:function(z_rate = 0.0)
	{
		if (this.斜投影法) {
			var rad = this.斜投影法deg * Math.PI /180;
			var cos = Math.cos(rad);
			this.ctx.transform(1, 0, -cos, 0.5, cos*this.h_d2, this.h_d2 - this.h_d2*z_rate/5);
		}
	}
	,
	use_view_coordinate:function()
	{
		this.ctx.resetTransform();
		this.use_投影法();
	}
	,
	use_model_coordinate:function(z_rate = 0.0)
	{
		// モデル座標系からビュー座標系への変換行列 (a b c d e f) を指定する
		// ビュー座標 vx,vy, モデル座標 mx,my に対し
		// [vx    [a c e
		//  vy  =  b d f  [mx my 1]
		//   1]    0 0 1]
		this.ctx.resetTransform();
		this.use_投影法(z_rate);
		this.ctx.transform(1.0/qt, 0.0, 0.0, -1.0/qt, this.w_d2, this.h_d2);
	}
	,
	use_model_font_coordinate:function(z_rate = 0.0)
	{
		this.ctx.transform(1.0, 0.0, 0.0, -1.0, 0, 0);
	}
	,
	set_color_width:function(color='#cccccc', width=1.0)
	{
		this.ctx.strokeStyle = color;
		this.ctx.lineWidth = width; // この値は transform の影響を受ける
	}
	,
	draw_axes:function() {
		this.use_view_coordinate();
		this.set_color_width('#cccccc', 1.0);
		this.draw_arrow(0, this.h_d2, this.w, this.h_d2); //x軸
		this.draw_arrow(this.w_d2, this.h, this.w_d2, 0); //y軸

		this.ctx.fillStyle = "rgba(0,0,0,0.5)";
		this.ctx.font = "10.5px 'sans-serif'";
		var metrics = this.ctx.measureText("Ze"); //対象文字列が描画文字列と不一致でも用が足りる
		this.ctx.fillText("X", this.w-metrics.width, this.h_d2);
		this.ctx.fillText("Y", this.w_d2, metrics.fontBoundingBoxAscent);

		if (this.斜投影法) {
			this.ctx.resetTransform(); //強制的に正投影(view座標系)にして
			this.draw_arrow(this.w_d2, this.h, this.w_d2, 0); //z軸
			this.ctx.fillText("Z", this.w_d2, metrics.fontBoundingBoxAscent);
		}
	}
	,
	draw_arrow:function(x1,y1, x2,y2, ar=6)
	{
		var ctx = this.ctx;
		var x3,y3, x4,y4;
		[x3,y3, x4,y4] = this.get_arrow_tail(x1,y1, x2,y2, ar);
		ctx.beginPath();
		ctx.moveTo(x1,y1);
		ctx.lineTo(x2,y2);
		ctx.lineTo(x3,y3);
		ctx.moveTo(x2,y2);
		ctx.lineTo(x4,y4);
		ctx.stroke();
	}
	,
	draw_edge:function(i) {
		//this.use_model_coordinate();
		var ctx = this.ctx;
		var e1 = model.edges[i];
		var n1 = model.nodes[e1.n1];
		var n2 = model.nodes[e1.n2];
		var x1 = n1.cx;
		var y1 = n1.cy;
		var x2 = n2.cx;
		var y2 = n2.cy;
		//console.log(x1, y1, x2, y2);
		if (Math.abs(x2-x1) < (n1.w/2 + n2.w/2) &&
			Math.abs(y2-y1) < (n1.h/2 + n2.h/2)) {
			return;
		}
		var xe1, ye1, xe2, ye2;
		[xe1, ye1] = n1.get_boundary_from_point(x2, y2);
		[xe2, ye2] = n2.get_boundary_from_point(x1, y1);
		if (isNaN(xe1)|| isNaN(ye1)|| isNaN(xe2)|| isNaN(ye2)) {
			return;
		}
		this.set_color_width(e1.line_col, e1.line_w);
		this.draw_arrow(xe1,ye1, xe2,ye2, 6*qt);
	}
	,
	draw_node:function(i) {
		var ctx = this.ctx;
		var node_cnt = model.node_cnt;
		ctx.beginPath();

		var n1 = model.nodes[i];
		//console.log("node 4b ", i, n1.cx,n1.cy,n1.z);

		//this.use_model_coordinate(1.0*n1.z/node_cnt);
		this.use_model_coordinate();
		
		ctx.lineWidth = n1.line_w;
		ctx.strokeStyle = n1.line_col;
		ctx.fillStyle = "rgba(255,255,255,0.75)";
		// transform が効いてmodel座標系指定なので、左下点xyと、右上点へのwhを指定、する
		ctx.fillRect  (n1.cx - n1.w/2, n1.cy - n1.h/2, n1.w, n1.h);
		ctx.strokeRect(n1.cx - n1.w/2, n1.cy - n1.h/2, n1.w, n1.h);
		ctx.stroke();

		ctx.beginPath();
		// 文字列
		// Y反転の座標系(Yが上に増える)だと、文字も上下反転してしまう。
		// そのため、文字列描画用のYが逆方向の座標軸用matrixを設定して、文字列描画APIに-Yを指定する。
		this.use_model_font_coordinate();
		var t1 = n1.text;
		var pt = 12 * qt;
		ctx.font = "" +pt+ "px 'sans-serif'";
		ctx.fillStyle = n1.line_col;

		//var metrics = ctx.measureText(t1);
		//ctx.fillText(t1, n1.cx-metrics.width/2, -n1.cy+metrics.ideographicBaseline);
		ctx.textAlign = "center";
		ctx.fillText(t1, n1.cx, -n1.cy);


		if (false && this.斜投影法) {
			this.use_model_coordinate(1.0*n1.z/node_cnt);
			//this.use_model_coordinate();

			ctx.strokeRect(n1.cx - n1.w/2, n1.cy - n1.h/2, n1.w, n1.h);
		}
		ctx.stroke();
	}
	,
	draw:function() {
		"use strict";
		this.gframe = (this.gframe < 29)? (this.gframe + 1): 0;
		this.ctx.reset();

		//axe
		//this.use_view_coordinate();
		this.draw_axes();

		//model.dump_nodes();
		if (this.斜投影法) {
			model.sort_y_neg();
		} else {
			model.sort_z();
		}
		//model.dump_nodes();

		//edge
		this.use_model_coordinate();
		for (var i=0; i < model.edge_cnt; i++) {
			this.draw_edge(i);
		}

		//node
		this.use_model_coordinate();
		for (var i=0; i < model.node_cnt; i++) {
			var idx = model.node_idx[i];
			//console.log("sorted idx", idx);
			this.draw_node(idx);
		}

		this.put_frame();
	}
	,
	put_frame:function() {
		view.val1.value = view.gframe;
	}

	// user's control i/f
	,
	ui_click_canvas:function(e) {
		var rect = view.canvas.getBoundingClientRect();
		var x = e.clientX - rect.left;
		var y = e.clientY - rect.top;
		//モデル座標
		var mx, my;
		[mx, my] = get_modelXY_from_viewXY(x, y);
		//console.info("x,y mx,my", x,y, mx,my);
		var n1 = model.select_node(mx, my);
		if (null != n1) {
			//console.log("click hit:", n1.text);
			view.val1.value = n1.text;
		} else {
			view.put_frame();
		}
	}
	,
	ui_click_a:function() {
		view.斜投影法 = false;
		view.draw();
	}
	,
	ui_click_b:function() {
		view.斜投影法 = true;
		view.draw();
	}
	,
	ui_click_run:function() {
		model.start();
	}
	,
	ui_click_stop:function() {
		model.stop();
	}
	,
	ui_click_reset:function() {
		model.reinit();
		view.draw();
		//model.start();
	}
	,
	ui_onload:function() { // @@@ entry point
		model.init();
		view.init();
		view.draw();
		//model.start();
	}
}

/////////////////////////////////////////

var keyst = {
	l:false
	,r:false
	,u:false
	,d:false
	,b1:false
	,b2:false
	,b3:false
	,b4:false
}

var key_conf = {
	l:37
	,r:39
	,u:38
	,d:40
	,b1:32 //spc*/
	,b2:90 //z
	,b3:88 //x
	//,b4:67 //c
	,b4:13 //ent
}

function keyCode(e) {
	if(document.all)
		return e.keyCode;
	if(document.getElementById)
		return (e.keyCode)? e.keyCode: e.charCode;
	if(document.layers)
		return e.which;
	return 0;
}

document.onkeydown = function(e) {
	var rc = false;
	try {
		var k = keyCode(e);
		if     ( k == key_conf.l ) keyst.l = true;
		else if( k == key_conf.r ) keyst.r = true;
		else if( k == key_conf.u ) keyst.u = true;
		else if( k == key_conf.d ) keyst.d = true;
		else if( k == key_conf.b1 ) keyst.b1 = true;
		else if( k == key_conf.b2 ) keyst.b2 = true;
		else if( k == key_conf.b3 ) keyst.b3 = true;
		else if( k == key_conf.b4 ) keyst.b4 = true;

		else if( 112 <= k && k <= 123 ) rc = true;/*F1-F12*/
	}
	catch(ex) {
		console.error(ex);
		alert(ex);
	}
	return rc;
}

document.onkeyup = function(e) {
	var rc = false;
	try {
		var k = keyCode(e);
		if     ( k == key_conf.l ) keyst.l = false;
		else if( k == key_conf.r ) keyst.r = false;
		else if( k == key_conf.u ) keyst.u = false;
		else if( k == key_conf.d ) keyst.d = false;
		else if( k == key_conf.b1 ) keyst.b1 = false;
		else if( k == key_conf.b2 ) keyst.b2 = false;
		else if( k == key_conf.b3 ) keyst.b3 = false;
		else if( k == key_conf.b4 ) keyst.b4 = false;

		else if( 112 <= k && k <= 123 ) rc = true;/*F1-F12*/
	}
	catch(ex) {
		console.error(ex);
		alert(ex);
	}
	return rc;
}

document.onkeypress = function(e) {
	var rc = false;
	var k = keyCode(e);
	if( 112 <= k && k <= 123 ) rc = true;/*F1-F12*/
	return rc;
}


// Local Variables:
// mode:javascript
// tab-width:4
// End:
